//Gemma-7B DATASET v1.0 Category: Network Ping Test ; Style: peaceful
#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>
#include <unistd.h>

#define MAX_HOSTS 10

int main() {
  int i, host_num = 0, ping_status;
  char host_list[MAX_HOSTS][256];

  // Generate a list of hosts to ping
  for (i = 0; i < MAX_HOSTS; i++) {
    sprintf(host_list[i], "192.168.1.%d", i + 1);
  }

  // Ping each host
  for (i = 0; i < MAX_HOSTS; i++) {
    struct sockaddr_in serv_addr;
    char ping_reply[1024];
    int sockfd;

    // Create a socket
    sockfd = socket(AF_INET, SOCK_DGRAM, htons(8));

    // Set up the server address
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_port = htons(5000);
    inet_aton(host_list[i], &serv_addr.sin_addr);

    // Send a ping message
    sendto(sockfd, "PING", 5, 0, (struct sockaddr *)&serv_addr, sizeof(serv_addr));

    // Receive the ping reply
    recvfrom(sockfd, ping_reply, 1024, 0, (struct sockaddr *)&serv_addr, NULL);

    // Check if the ping was successful
    ping_status = strcmp(ping_reply, "PONG");
    if (ping_status == 0) {
      printf("Host: %s is online.\n", host_list[i]);
    } else {
      printf("Host: %s is offline.\n", host_list[i]);
    }

    // Close the socket
    close(sockfd);
  }

  return 0;
}