//Falcon-180B DATASET v1.0 Category: Password Strength Checker ; Style: decentralized
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#define MAX_LENGTH 50

int main() {
    char password[MAX_LENGTH];
    int length, i;

    printf("Enter a password: ");
    fgets(password, MAX_LENGTH, stdin);
    length = strlen(password);

    if (length < 8) {
        printf("Password must be at least 8 characters long.\n");
        return 0;
    }

    int has_uppercase = 0;
    int has_lowercase = 0;
    int has_digit = 0;
    int has_special = 0;

    for (i = 0; i < length; i++) {
        if (isupper(password[i])) {
            has_uppercase = 1;
        } else if (islower(password[i])) {
            has_lowercase = 1;
        } else if (isdigit(password[i])) {
            has_digit = 1;
        } else if (password[i] == '!' || password[i] == '@' ||
                   password[i] == '#' || password[i] == '$' ||
                   password[i] == '%' || password[i] == '&' ||
                   password[i] == '*' || password[i] == '?') {
            has_special = 1;
        }
    }

    int score = 0;

    if (has_uppercase) {
        score++;
    }

    if (has_lowercase) {
        score++;
    }

    if (has_digit) {
        score++;
    }

    if (has_special) {
        score++;
    }

    if (score < 3) {
        printf("Password is weak.\n");
    } else {
        printf("Password is strong.\n");
    }

    return 0;
}