//Falcon-180B DATASET v1.0 Category: Fitness Tracker ; Style: imaginative
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define PI 3.14159265358979323846

struct workout {
    char name[30];
    int duration;
    int calories;
};

// Function to calculate calories burned based on duration and intensity of workout
int calculateCalories(int duration, int intensity) {
    float calories = ((7.0 * intensity * duration) / 200.0) - 6.0;
    return (int)round(calories);
}

// Function to calculate distance traveled based on duration and speed of workout
float calculateDistance(int duration, float speed) {
    float distance = speed * duration;
    return distance;
}

// Function to calculate average heart rate based on maximum and minimum heart rates during workout
float calculateAverageHeartRate(int maxHeartRate, int minHeartRate) {
    float averageHeartRate = ((3 * maxHeartRate) + (2 * minHeartRate)) / 5.0;
    return averageHeartRate;
}

// Function to print workout summary
void printWorkoutSummary(struct workout workout) {
    printf("Workout Name: %s\n", workout.name);
    printf("Duration: %d minutes\n", workout.duration);
    printf("Calories Burned: %d\n", workout.calories);
    printf("Average Heart Rate: %d bpm\n", calculateAverageHeartRate(120, 100)); // placeholder for actual heart rate values
    printf("Distance Traveled: %f miles\n", calculateDistance(workout.duration, 6.0)); // placeholder for actual speed values
}

int main() {
    struct workout workout1 = {"Running", 30, 250};
    printWorkoutSummary(workout1);

    struct workout workout2 = {"Cycling", 45, 350};
    printWorkoutSummary(workout2);

    struct workout workout3 = {"Swimming", 60, 400};
    printWorkoutSummary(workout3);

    return 0;
}