//GPT-4o-mini DATASET v1.0 Category: Wi-Fi Signal Strength Analyzer ; Style: statistical
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <stdint.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#define MAX_SAMPLES 100
#define SSID_LEN 32

typedef struct {
    char ssid[SSID_LEN];
    int strength[MAX_SAMPLES];
    int sample_count;
    float average;
    float std_deviation;
} WifiSignal;

float calculate_average(int* data, int count) {
    float sum = 0.0;
    for (int i = 0; i < count; i++) {
        sum += data[i];
    }
    return sum / count;
}

float calculate_std_deviation(int* data, int count, float average) {
    float sum = 0.0;
    for (int i = 0; i < count; i++) {
        sum += (data[i] - average) * (data[i] - average);
    }
    return sqrt(sum / count);
}

void add_sample(WifiSignal* wifi_signal, int signal_strength) {
    if (wifi_signal->sample_count < MAX_SAMPLES) {
        wifi_signal->strength[wifi_signal->sample_count] = signal_strength;
        wifi_signal->sample_count++;
    } else {
        fprintf(stderr, "Maximum samples reached for %s. Not adding new sample.\n", wifi_signal->ssid);
    }
}

void update_statistics(WifiSignal* wifi_signal) {
    if (wifi_signal->sample_count > 0) {
        wifi_signal->average = calculate_average(wifi_signal->strength, wifi_signal->sample_count);
        wifi_signal->std_deviation = calculate_std_deviation(wifi_signal->strength, wifi_signal->sample_count, wifi_signal->average);
    }
}

void print_signal_statistics(WifiSignal* wifi_signal) {
    printf("Wi-Fi SSID: %s\n", wifi_signal->ssid);
    printf("Samples Collected: %d\n", wifi_signal->sample_count);
    printf("Average Signal Strength: %.2f dBm\n", wifi_signal->average);
    printf("Standard Deviation: %.2f dBm\n", wifi_signal->std_deviation);
}

void simulate_wifi_signal_collecting(WifiSignal* wifi_signal) {
    for (int i = 0; i < 10; i++) {
        int sample = rand() % 100 - 100; // Simulate a signal strength between -100 and 0
        add_sample(wifi_signal, sample);
        usleep(500000); // Wait for half a second between samples
    }
}

int main() {
    srand(time(NULL)); // Seed for random number generation
    WifiSignal wifi_signal = {"MyHomeWiFi", {0}, 0, 0.0, 0.0};

    printf("Starting Wi-Fi Signal Strength Analyzer...\n");

    simulate_wifi_signal_collecting(&wifi_signal);
    update_statistics(&wifi_signal);
    print_signal_statistics(&wifi_signal);

    // Create a file to log the signal statistics
    char filename[64];
    snprintf(filename, sizeof(filename), "%s_stats.txt", wifi_signal.ssid);
    FILE* log_file = fopen(filename, "w");
    if (log_file == NULL) {
        fprintf(stderr, "Error: Could not open log file for writing.\n");
        return EXIT_FAILURE;
    }

    fprintf(log_file, "Wi-Fi SSID: %s\n", wifi_signal.ssid);
    fprintf(log_file, "Samples Collected: %d\n", wifi_signal.sample_count);
    fprintf(log_file, "Average Signal Strength: %.2f dBm\n", wifi_signal.average);
    fprintf(log_file, "Standard Deviation: %.2f dBm\n", wifi_signal.std_deviation);
    fclose(log_file);

    printf("Signal statistics have been logged to: %s\n", filename);
    
    return EXIT_SUCCESS;
}