//Falcon-180B DATASET v1.0 Category: Electronic Voting System ; Style: automated
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_CANDIDATES 10
#define MAX_VOTERS 1000
#define MAX_NAME_LENGTH 50
#define MAX_PASSWORD_LENGTH 20

typedef struct {
    char name[MAX_NAME_LENGTH + 1];
    char password[MAX_PASSWORD_LENGTH + 1];
    int is_admin;
} User;

typedef struct {
    char name[MAX_NAME_LENGTH + 1];
    int votes;
} Candidate;

User users[MAX_VOTERS];
Candidate candidates[MAX_CANDIDATES];
int num_candidates = 0;
int num_voters = 0;

void add_candidate(char* name) {
    if (num_candidates >= MAX_CANDIDATES) {
        printf("Error: Maximum number of candidates reached.\n");
        return;
    }
    strcpy(candidates[num_candidates].name, name);
    candidates[num_candidates].votes = 0;
    num_candidates++;
}

void add_user(char* name, char* password) {
    if (num_voters >= MAX_VOTERS) {
        printf("Error: Maximum number of voters reached.\n");
        return;
    }
    strcpy(users[num_voters].name, name);
    strcpy(users[num_voters].password, password);
    users[num_voters].is_admin = 0;
    num_voters++;
}

int authenticate_user(char* name, char* password) {
    for (int i = 0; i < num_voters; i++) {
        if (strcmp(name, users[i].name) == 0 && strcmp(password, users[i].password) == 0) {
            return i;
        }
    }
    return -1;
}

void vote(int voter_id, int candidate_id) {
    if (voter_id < 0 || voter_id >= num_voters) {
        printf("Error: Invalid voter ID.\n");
        return;
    }
    if (candidate_id < 0 || candidate_id >= num_candidates) {
        printf("Error: Invalid candidate ID.\n");
        return;
    }
    candidates[candidate_id].votes++;
}

void print_results() {
    for (int i = 0; i < num_candidates; i++) {
        printf("%s: %d votes\n", candidates[i].name, candidates[i].votes);
    }
}

int main() {
    add_candidate("Candidate 1");
    add_candidate("Candidate 2");
    add_candidate("Candidate 3");
    add_user("User 1", "password1");
    add_user("User 2", "password2");
    add_user("Admin", "admin_password");

    int user_id = authenticate_user("User 1", "password1");
    if (user_id >= 0) {
        printf("User 1 logged in successfully.\n");
    }

    user_id = authenticate_user("User 2", "password2");
    if (user_id >= 0) {
        printf("User 2 logged in successfully.\n");
    }

    user_id = authenticate_user("Admin", "admin_password");
    if (user_id >= 0) {
        printf("Admin logged in successfully.\n");
    }

    vote(0, 0);
    vote(1, 1);
    vote(2, 0);
    vote(2, 1);
    vote(2, 2);
    print_results();

    return 0;
}