//GPT-4o-mini DATASET v1.0 Category: Interprocess communication ; Style: Donald Knuth
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#define BUFFER_SIZE 256
#define MESSAGE "Hello, child process! Here is your message."
#define CHILD_MESSAGE "Hello, parent process! Acknowledged."

void handle_error(const char *msg) {
    perror(msg);
    exit(EXIT_FAILURE);
}

int main() {
    int pipe_fd[2];
    pid_t pid;
    char buffer[BUFFER_SIZE];

    // Create a pipe
    if (pipe(pipe_fd) == -1) {
        handle_error("pipe");
    }

    // Fork to create a child process
    if ((pid = fork()) == -1) {
        handle_error("fork");
    }

    // Child process
    if (pid == 0) {
        close(pipe_fd[1]); // Close unused write end

        // Read message from the parent
        if (read(pipe_fd[0], buffer, sizeof(buffer)) == -1) {
            handle_error("read");
        }
        
        printf("Child received message: %s\n", buffer);
        
        // Sending acknowledgment back to parent
        const char *ack_message = CHILD_MESSAGE;
        if (write(pipe_fd[0], ack_message, strlen(ack_message) + 1) == -1) {
            handle_error("write");
        }

        close(pipe_fd[0]); // Close the read end
        exit(EXIT_SUCCESS);
    } 
    // Parent process
    else {
        close(pipe_fd[0]); // Close unused read end

        // Send message to the child
        if (write(pipe_fd[1], MESSAGE, strlen(MESSAGE) + 1) == -1) {
            handle_error("write");
        }
        printf("Parent sent message: %s\n", MESSAGE);
        
        // Wait for the acknowledgment from the child
        if (read(pipe_fd[1], buffer, sizeof(buffer)) == -1) {
            handle_error("read");
        }
        printf("Parent received acknowledgment: %s\n", buffer);

        close(pipe_fd[1]); // Close the write end
        wait(NULL); // Wait for the child process to finish
    }

    return 0;
}