//Code Llama-13B DATASET v1.0 Category: Ebook reader ; Style: lively
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Structure to represent a book
struct Book {
    char title[50];
    char author[50];
    char pages[50];
    char genre[50];
};

// Function to display a book
void displayBook(struct Book book) {
    printf("Title: %s\n", book.title);
    printf("Author: %s\n", book.author);
    printf("Pages: %s\n", book.pages);
    printf("Genre: %s\n", book.genre);
}

// Function to add a book to the library
void addBook(struct Book book, struct Book *library, int size) {
    library[size] = book;
    size++;
}

// Function to remove a book from the library
void removeBook(struct Book *library, int size, int index) {
    for (int i = index; i < size - 1; i++) {
        library[i] = library[i + 1];
    }
    size--;
}

// Function to search for a book in the library
struct Book searchBook(struct Book *library, int size, char title[50]) {
    for (int i = 0; i < size; i++) {
        if (strcmp(library[i].title, title) == 0) {
            return library[i];
        }
    }
    return (struct Book){};
}

int main() {
    // Create a library of 50 books
    struct Book library[50];
    int size = 0;

    // Add books to the library
    struct Book book1 = {"The Alchemist", "Paulo Coelho", "288", "Fiction"};
    struct Book book2 = {"The Catcher in the Rye", "J.D. Salinger", "288", "Fiction"};
    struct Book book3 = {"The Little Prince", "Antoine de Saint-Exupéry", "104", "Fiction"};
    struct Book book4 = {"The Name of the Rose", "Umberto Eco", "528", "Fiction"};
    struct Book book5 = {"The Great Gatsby", "F. Scott Fitzgerald", "224", "Fiction"};
    addBook(book1, library, size);
    addBook(book2, library, size);
    addBook(book3, library, size);
    addBook(book4, library, size);
    addBook(book5, library, size);

    // Search for a book in the library
    struct Book searchedBook = searchBook(library, size, "The Great Gatsby");
    if (searchedBook.title[0] != '\0') {
        displayBook(searchedBook);
    } else {
        printf("Book not found!\n");
    }

    // Remove a book from the library
    removeBook(library, size, 2);

    // Display all books in the library
    for (int i = 0; i < size; i++) {
        displayBook(library[i]);
    }

    return 0;
}