//Falcon2-11B DATASET v1.0 Category: Product Inventory System ; Style: ephemeral
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct {
    char name[50];
    float price;
    int quantity;
} Product;

void add_product(Product* products, int* n, char* name, float price, int quantity) {
    if (*n >= 100) {
        printf("Inventory full, cannot add more products.\n");
        return;
    }

    Product temp = {name, price, quantity};
    products[*n] = temp;
    (*n)++;
}

void delete_product(Product* products, int* n, char* name) {
    for (int i = 0; i < *n; i++) {
        if (strcmp(products[i].name, name) == 0) {
            for (int j = i; j < *n - 1; j++) {
                products[j] = products[j + 1];
            }
            (*n)--;
            return;
        }
    }

    printf("Product not found in inventory.\n");
}

void update_product(Product* products, int* n, char* name, float price, int quantity) {
    for (int i = 0; i < *n; i++) {
        if (strcmp(products[i].name, name) == 0) {
            products[i].price = price;
            products[i].quantity = quantity;
            return;
        }
    }

    printf("Product not found in inventory.\n");
}

void display_inventory(Product* products, int n) {
    printf("Product Inventory\n");
    for (int i = 0; i < n; i++) {
        printf("%s - $%.2f - %d\n", products[i].name, products[i].price, products[i].quantity);
    }
}

int main() {
    Product products[100];
    int n = 0;

    add_product(products, &n, "iPhone 12", 999.99, 10);
    add_product(products, &n, "Samsung Galaxy S21", 899.99, 5);
    add_product(products, &n, "Apple Watch Series 6", 499.99, 20);
    add_product(products, &n, "Google Pixel 5", 699.99, 15);

    display_inventory(products, n);

    delete_product(products, &n, "Samsung Galaxy S21");
    update_product(products, &n, "Apple Watch Series 6", 599.99, 25);

    display_inventory(products, n);

    return 0;
}