//Gemma-7B DATASET v1.0 Category: Haunted House Simulator ; Style: genius
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_GHOSTS 5

typedef struct Ghost {
    char name[20];
    int age;
    float haunt_score;
    int room_num;
} Ghost;

Ghost ghosts[MAX_GHOSTS];

void initializeGhosts() {
    for (int i = 0; i < MAX_GHOSTS; i++) {
        ghosts[i].name[0] = '\0';
        ghosts[i].age = 0;
        ghosts[i].haunt_score = 0.0f;
        ghosts[i].room_num = 0;
    }
}

void addGhost(char *name, int age, float haunt_score, int room_num) {
    for (int i = 0; i < MAX_GHOSTS; i++) {
        if (ghosts[i].name[0] == '\0') {
            strcpy(ghosts[i].name, name);
            ghosts[i].age = age;
            ghosts[i].haunt_score = haunt_score;
            ghosts[i].room_num = room_num;
            return;
        }
    }

    printf("Error: No more ghosts can be added.\n");
}

void haunt(int room_num) {
    for (int i = 0; i < MAX_GHOSTS; i++) {
        if (ghosts[i].room_num == room_num) {
            printf("Ghostly presence: %s\n", ghosts[i].name);
            printf("You feel a cold breeze and hear whispers in the wind.\n");
            printf("The hairs on your neck stand on end, and you feel like you are being watched.\n");
            return;
        }
    }

    printf("There is no ghost in this room.\n");
}

int main() {
    initializeGhosts();

    addGhost("The Banshee", 18, 9.5f, 3);
    addGhost("The Phantom", 22, 8.2f, 5);
    addGhost("The Ghost Bride", 20, 7.1f, 2);

    haunt(3);
    haunt(5);

    return 0;
}