//Falcon2-11B DATASET v1.0 Category: Database Indexing System ; Style: future-proof
#include <stdio.h>
#include <stdlib.h>
#include <sqlite3.h>

// Function to create a database and initialize it with some data
void createDatabase(const char* dbPath, int numRows) {
    sqlite3 *db;
    char *zErrMsg = 0;

    if (sqlite3_open(dbPath, &db)!= SQLITE_OK) {
        fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
        exit(1);
    }

    sqlite3_exec(db, "CREATE TABLE users (id INTEGER PRIMARY KEY, name TEXT, age INTEGER)", 0, 0, &zErrMsg);
    if (zErrMsg) {
        fprintf(stderr, "SQL error: %s\n", zErrMsg);
        sqlite3_free(zErrMsg);
        exit(1);
    }

    for (int i = 0; i < numRows; i++) {
        char *query = "INSERT INTO users VALUES (?,?,?)";
        sqlite3_stmt *stmt;
        int rc = sqlite3_prepare_v2(db, query, -1, &stmt, 0);
        if (rc!= SQLITE_OK) {
            fprintf(stderr, "SQL error: %s\n", sqlite3_errmsg(db));
            exit(1);
        }

        sqlite3_bind_int(stmt, 1, i + 1);
        sqlite3_bind_text(stmt, 2, "User " + (i + 1), -1, SQLITE_TRANSIENT);
        sqlite3_bind_int(stmt, 3, (i + 1) * 10);

        rc = sqlite3_step(stmt);
        if (rc!= SQLITE_DONE) {
            fprintf(stderr, "SQL error: %s\n", sqlite3_errmsg(db));
            exit(1);
        }
    }

    sqlite3_close(db);
}

// Function to create an index on a column
void createIndex(sqlite3 *db, const char *tableName, const char *columnName) {
    char *zErrMsg = 0;

    if (sqlite3_exec(db, "CREATE INDEX index_%s ON %s (%s)", tableName, columnName, columnName)!= SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", sqlite3_errmsg(db));
        sqlite3_free(zErrMsg);
        exit(1);
    }

    sqlite3_free(zErrMsg);
}

int main() {
    const char* dbPath = "database.db";
    const char* tableName = "users";
    const char* columnName = "name";

    createDatabase(dbPath, 10);
    createIndex(dbPath, tableName, columnName);

    return 0;
}