//GEMINI-pro DATASET v1.0 Category: Banking Record System ; Style: ultraprecise
#include <stdio.h>
#include <stdlib.h>

// Define the maximum number of accounts and transactions
#define MAX_ACCOUNTS 100
#define MAX_TRANSACTIONS 1000

// Define the account structure
typedef struct {
  int account_number;
  char *name;
  double balance;
} account_t;

// Define the transaction structure
typedef struct {
  int transaction_id;
  int account_number;
  char *description;
  double amount;
} transaction_t;

// Create an array of accounts
account_t accounts[MAX_ACCOUNTS];

// Create an array of transactions
transaction_t transactions[MAX_TRANSACTIONS];

// Initialize the number of accounts and transactions
int num_accounts = 0;
int num_transactions = 0;

// Function to create a new account
void create_account(int account_number, char *name, double balance) {
  // Check if the account number is already in use
  for (int i = 0; i < num_accounts; i++) {
    if (accounts[i].account_number == account_number) {
      printf("Error: Account number already in use.\n");
      return;
    }
  }

  // Create the new account
  accounts[num_accounts].account_number = account_number;
  accounts[num_accounts].name = name;
  accounts[num_accounts].balance = balance;

  // Increment the number of accounts
  num_accounts++;
}

// Function to deposit money into an account
void deposit(int account_number, double amount) {
  // Find the account
  int account_index = -1;
  for (int i = 0; i < num_accounts; i++) {
    if (accounts[i].account_number == account_number) {
      account_index = i;
      break;
    }
  }

  // Check if the account was found
  if (account_index == -1) {
    printf("Error: Account not found.\n");
    return;
  }

  // Deposit the money
  accounts[account_index].balance += amount;
}

// Function to withdraw money from an account
void withdraw(int account_number, double amount) {
  // Find the account
  int account_index = -1;
  for (int i = 0; i < num_accounts; i++) {
    if (accounts[i].account_number == account_number) {
      account_index = i;
      break;
    }
  }

  // Check if the account was found
  if (account_index == -1) {
    printf("Error: Account not found.\n");
    return;
  }

  // Withdraw the money
  accounts[account_index].balance -= amount;
}

// Function to transfer money between accounts
void transfer(int from_account_number, int to_account_number, double amount) {
  // Find the from account
  int from_account_index = -1;
  for (int i = 0; i < num_accounts; i++) {
    if (accounts[i].account_number == from_account_number) {
      from_account_index = i;
      break;
    }
  }

  // Check if the from account was found
  if (from_account_index == -1) {
    printf("Error: From account not found.\n");
    return;
  }

  // Find the to account
  int to_account_index = -1;
  for (int i = 0; i < num_accounts; i++) {
    if (accounts[i].account_number == to_account_number) {
      to_account_index = i;
      break;
    }
  }

  // Check if the to account was found
  if (to_account_index == -1) {
    printf("Error: To account not found.\n");
    return;
  }

  // Transfer the money
  accounts[from_account_index].balance -= amount;
  accounts[to_account_index].balance += amount;
}

// Function to print the account information
void print_account(int account_number) {
  // Find the account
  int account_index = -1;
  for (int i = 0; i < num_accounts; i++) {
    if (accounts[i].account_number == account_number) {
      account_index = i;
      break;
    }
  }

  // Check if the account was found
  if (account_index == -1) {
    printf("Error: Account not found.\n");
    return;
  }

  // Print the account information
  printf("Account Number: %d\n", accounts[account_index].account_number);
  printf("Name: %s\n", accounts[account_index].name);
  printf("Balance: %f\n", accounts[account_index].balance);
}

// Function to print the transaction history
void print_transactions(int account_number) {
  // Find the account
  int account_index = -1;
  for (int i = 0; i < num_accounts; i++) {
    if (accounts[i].account_number == account_number) {
      account_index = i;
      break;
    }
  }

  // Check if the account was found
  if (account_index == -1) {
    printf("Error: Account not found.\n");
    return;
  }

  // Print the transaction history
  for (int i = 0; i < num_transactions; i++) {
    if (transactions[i].account_number == account_number) {
      printf("Transaction ID: %d\n", transactions[i].transaction_id);
      printf("Description: %s\n", transactions[i].description);
      printf("Amount: %f\n", transactions[i].amount);
    }
  }
}

// Main function
int main() {
  // Create some accounts
  create_account(123456789, "John Doe", 1000.00);
  create_account(987654321, "Jane Doe", 2000.00);

  // Deposit some money into the accounts
  deposit(123456789, 500.00);
  deposit(987654321, 1000.00);

  // Withdraw some money from the accounts
  withdraw(123456789, 200.00);
  withdraw(987654321, 500.00);

  // Transfer some money between the accounts
  transfer(123456789, 987654321, 300.00);

  // Print the account information
  print_account(123456789);
  print_account(987654321);

  // Print the transaction history
  print_transactions(123456789);
  print_transactions(987654321);

  return 0;
}