//Falcon-180B DATASET v1.0 Category: Data mining ; Style: shocked
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 100
#define MAX_CATEGORIES 10
#define MAX_CATEGORY_NAME_LENGTH 50
#define MAX_ITEM_NAME_LENGTH 50

typedef struct {
    char category[MAX_CATEGORY_NAME_LENGTH];
    int category_id;
} Category;

typedef struct {
    char name[MAX_ITEM_NAME_LENGTH];
    int category_id;
    int quantity;
} Item;

int category_count = 0;
Category categories[MAX_CATEGORIES];
int item_count = 0;
Item items[MAX_ITEMS];

void add_category(char* category_name) {
    strcpy(categories[category_count].category, category_name);
    categories[category_count].category_id = category_count;
    category_count++;
}

int get_category_id(char* category_name) {
    for (int i = 0; i < category_count; i++) {
        if (strcmp(categories[i].category, category_name) == 0) {
            return categories[i].category_id;
        }
    }
    add_category(category_name);
    return category_count - 1;
}

void add_item(char* item_name, int category_id, int quantity) {
    strcpy(items[item_count].name, item_name);
    items[item_count].category_id = category_id;
    items[item_count].quantity = quantity;
    item_count++;
}

void print_categories() {
    printf("Categories:\n");
    for (int i = 0; i < category_count; i++) {
        printf("%d. %s\n", i, categories[i].category);
    }
}

void print_items(int category_id) {
    printf("Items in category %s:\n", categories[category_id].category);
    for (int i = 0; i < item_count; i++) {
        if (items[i].category_id == category_id) {
            printf("%d. %s - %d\n", i, items[i].name, items[i].quantity);
        }
    }
}

int main() {
    // Add categories
    add_category("Electronics");
    add_category("Clothing");
    add_category("Books");

    // Add items
    add_item("iPhone", 0, 10);
    add_item("Samsung Galaxy", 0, 5);
    add_item("T-Shirt", 1, 20);
    add_item("Jeans", 1, 15);
    add_item("Harry Potter", 2, 30);

    // Print categories and items
    print_categories();
    print_items(0);
    print_items(1);
    print_items(2);

    return 0;
}