//Falcon-180B DATASET v1.0 Category: Fractal Generation ; Style: innovative
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <GL/glut.h>

void init() {
    glClearColor(0.0, 0.0, 0.0, 0.0);
    gluOrtho2D(0.0, 600.0, 0.0, 400.0);
}

void display() {
    glClear(GL_COLOR_BUFFER_BIT);
    glColor3f(1.0, 1.0, 1.0);
    glBegin(GL_POLYGON);
    glVertex2i(0, 400);
    glVertex2i(600, 400);
    glVertex2i(600, 0);
    glEnd();
}

void fractal(int x1, int y1, int x2, int y2, int depth) {
    if (depth == 0) {
        glBegin(GL_POLYGON);
        glVertex2i(x1, y1);
        glVertex2i(x1, y2);
        glVertex2i(x2, y2);
        glVertex2i(x2, y1);
        glEnd();
        return;
    }
    int deltaX = x2 - x1;
    int deltaY = y2 - y1;
    int newX1 = x1 + deltaX / 3;
    int newY1 = y1 + deltaY / 3;
    int newX2 = x2 - deltaX / 3;
    int newY2 = y2 - deltaY / 3;
    fractal(x1, y1, newX1, newY1, depth - 1);
    fractal(newX1, newY1, newX2, newY2, depth - 1);
    fractal(newX2, newY2, x2, y2, depth - 1);
}

int main(int argc, char **argv) {
    glutInit(&argc, argv);
    glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);
    glutInitWindowSize(600, 400);
    glutCreateWindow("Fractal");
    init();
    glutDisplayFunc(display);
    fractal(0, 400, 600, 0, 5);
    glutMainLoop();
    return 0;
}