//GEMINI-pro DATASET v1.0 Category: Time Travel Simulator ; Style: automated
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the maximum number of years that can be traveled
#define MAX_YEARS 100

// Define the minimum year that can be traveled to
#define MIN_YEAR 1900

// Define the maximum year that can be traveled to
#define MAX_YEAR 2100

// Get a random year between the minimum and maximum years
int get_random_year() {
  // Use the current time as the seed for the random number generator
  srand(time(NULL));

  // Generate a random number between 0 and 99
  int random_number = rand() % 100;

  // Add the minimum year to the random number to get a random year between the minimum and maximum years
  return MIN_YEAR + random_number;
}

// Get a random month between 1 and 12
int get_random_month() {
  // Generate a random number between 0 and 11
  int random_number = rand() % 12;

  // Add 1 to the random number to get a random month between 1 and 12
  return random_number + 1;
}

// Get a random day between 1 and 31
int get_random_day() {
  // Generate a random number between 0 and 30
  int random_number = rand() % 31;

  // Add 1 to the random number to get a random day between 1 and 31
  return random_number + 1;
}

// Get a random hour between 0 and 23
int get_random_hour() {
  // Generate a random number between 0 and 23
  int random_number = rand() % 24;

  // Add 1 to the random number to get a random day between 1 and 31
  return random_number;
}

// Get a random minute between 0 and 59
int get_random_minute() {
  // Generate a random number between 0 and 59
  int random_number = rand() % 60;

  // Add 1 to the random number to get a random day between 1 and 31
  return random_number;
}

// Get a random second between 0 and 59
int get_random_second() {
  // Generate a random number between 0 and 59
  int random_number = rand() % 60;

  // Add 1 to the random number to get a random day between 1 and 31
  return random_number;
}

// Print the current time
void print_current_time() {
  time_t current_time;
  struct tm *local_time;

  // Get the current time
  time(&current_time);

  // Convert the current time to a local time struct
  local_time = localtime(&current_time);

  // Print the current time
  printf("Current time: %s\n", asctime(local_time));
}

// Print a random time
void print_random_time() {
  int year = get_random_year();
  int month = get_random_month();
  int day = get_random_day();
  int hour = get_random_hour();
  int minute = get_random_minute();
  int second = get_random_second();

  // Print the random time
  printf("Random time: %04d-%02d-%02d %02d:%02d:%02d\n", year, month, day, hour, minute, second);
}

// Main function
int main() {
  // Print the current time
  print_current_time();

  // Print a random time
  print_random_time();

  return 0;
}