//Falcon-180B DATASET v1.0 Category: Password Strength Checker ; Style: calm
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

#define MAX_PASSWORD_LENGTH 20

int main() {
    char password[MAX_PASSWORD_LENGTH];
    int length;
    int upper_case_count = 0;
    int lower_case_count = 0;
    int digit_count = 0;
    int special_count = 0;
    int total_count = 0;

    printf("Enter your password: ");
    fgets(password, MAX_PASSWORD_LENGTH, stdin);
    length = strlen(password);

    if (length < 8) {
        printf("Password should be at least 8 characters long.\n");
        return 1;
    }

    for (int i = 0; i < length; i++) {
        if (isupper(password[i])) {
            upper_case_count++;
        } else if (islower(password[i])) {
            lower_case_count++;
        } else if (isdigit(password[i])) {
            digit_count++;
        } else if (password[i] == '!' || password[i] == '@' || password[i] == '#' || password[i] == '$' || password[i] == '%' || password[i] == '^' || password[i] == '&' || password[i] == '*') {
            special_count++;
        }
        total_count++;
    }

    int score = 0;

    if (upper_case_count > 0) {
        score++;
    }

    if (lower_case_count > 0) {
        score++;
    }

    if (digit_count > 0) {
        score++;
    }

    if (special_count > 0) {
        score++;
    }

    if (total_count > 1) {
        score++;
    }

    if (score == 0) {
        printf("Password is very weak.\n");
    } else if (score == 1) {
        printf("Password is weak.\n");
    } else if (score == 2) {
        printf("Password is moderate.\n");
    } else if (score == 3) {
        printf("Password is strong.\n");
    } else if (score == 4) {
        printf("Password is very strong.\n");
    }

    return 0;
}