//Falcon-180B DATASET v1.0 Category: Poker Game ; Style: real-life
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define DECK_SIZE 52
#define NUM_CARDS_DEALT 5
#define NUM_PLAYERS 2

enum CardSuit { HEARTS, DIAMONDS, CLUBS, SPADES };
enum CardRank { TWO, THREE, FOUR, FIVE, SIX, SEVEN, EIGHT, NINE, TEN, JACK, QUEEN, KING, ACE };

struct Card {
    enum CardSuit suit;
    enum CardRank rank;
};

void shuffleDeck(struct Card deck[DECK_SIZE]) {
    srand(time(NULL));
    
    for (int i = 0; i < DECK_SIZE; i++) {
        struct Card temp = deck[i];
        int randomIndex = rand() % DECK_SIZE;
        deck[i] = deck[randomIndex];
        deck[randomIndex] = temp;
    }
}

void dealCards(struct Card deck[DECK_SIZE], struct Card hand[NUM_CARDS_DEALT]) {
    for (int i = 0; i < NUM_CARDS_DEALT; i++) {
        hand[i] = deck[i];
    }
    
    for (int i = 0; i < DECK_SIZE - NUM_CARDS_DEALT; i++) {
        deck[i] = deck[i + NUM_CARDS_DEALT];
    }
}

int evaluateHand(struct Card hand[NUM_CARDS_DEALT]) {
    int value = 0;
    int numAces = 0;
    
    for (int i = 0; i < NUM_CARDS_DEALT; i++) {
        if (hand[i].rank == ACE) {
            numAces++;
        } else if (hand[i].rank == TWO || hand[i].rank == THREE || hand[i].rank == FOUR || hand[i].rank == FIVE || hand[i].rank == SIX || hand[i].rank == SEVEN || hand[i].rank == EIGHT || hand[i].rank == NINE || hand[i].rank == TEN || hand[i].rank == JACK || hand[i].rank == QUEEN || hand[i].rank == KING) {
            value += hand[i].rank * 10;
        } else if (hand[i].rank == ACE && numAces > 0) {
            value += 11;
            numAces--;
        } else if (hand[i].rank == ACE) {
            value += 1;
        } else {
            value += 10;
        }
    }
    
    return value;
}

int main() {
    struct Card deck[DECK_SIZE];
    for (int i = 0; i < DECK_SIZE; i++) {
        deck[i].suit = (enum CardSuit)i % 4;
        deck[i].rank = (enum CardRank)(i / 4) + 2;
    }
    
    shuffleDeck(deck);
    
    struct Card hand1[NUM_CARDS_DEALT];
    struct Card hand2[NUM_CARDS_DEALT];
    
    dealCards(deck, hand1);
    dealCards(deck, hand2);
    
    int hand1Value = evaluateHand(hand1);
    int hand2Value = evaluateHand(hand2);
    
    if (hand1Value > hand2Value) {
        printf("Player 1 wins!\n");
    } else if (hand2Value > hand1Value) {
        printf("Player 2 wins!\n");
    } else {
        printf("It's a tie!\n");
    }
    
    return 0;
}