//GPT-4o-mini DATASET v1.0 Category: Maze Route Finder ; Style: rigorous
#include <stdio.h>
#include <stdlib.h>

#define N 5  // Size of the maze (N x N)

int maze[N][N] = {
    {0, 1, 0, 0, 0},
    {0, 1, 0, 1, 0},
    {0, 0, 0, 1, 0},
    {0, 1, 1, 1, 0},
    {0, 0, 0, 0, 0}
};

void printMaze(int maze[N][N], int solution[N][N]) {
    for (int x = 0; x < N; x++) {
        for (int y = 0; y < N; y++) {
            if (solution[x][y] == 1) {
                printf(" * ");
            } else if (maze[x][y] == 0) {
                printf("   ");
            } else {
                printf(" . ");
            }
        }
        printf("\n");
    }
}

int isSafe(int maze[N][N], int x, int y) {
    return (x >= 0 && x < N && y >= 0 && y < N && maze[x][y] == 0);
}

int solveMazeUtil(int maze[N][N], int x, int y, int solution[N][N]) {
    if (x == N - 1 && y == N - 1) {
        solution[x][y] = 1;
        return 1;
    }

    if (isSafe(maze, x, y)) {
        solution[x][y] = 1;

        if (solveMazeUtil(maze, x + 1, y, solution)) {
            return 1;
        }

        if (solveMazeUtil(maze, x, y + 1, solution)) {
            return 1;
        }

        solution[x][y] = 0; // backtrack
    }
    return 0;
}

int solveMaze(int maze[N][N]) {
    int solution[N][N] = { {0, 0, 0, 0, 0},
                           {0, 0, 0, 0, 0},
                           {0, 0, 0, 0, 0},
                           {0, 0, 0, 0, 0},
                           {0, 0, 0, 0, 0} };

    if (solveMazeUtil(maze, 0, 0, solution) == 0) {
        printf("No solution exists\n");
        return 0;
    }

    printMaze(maze, solution);
    return 1;
}

int main() {
    printf("Maze Solution:\n");
    solveMaze(maze);
    return 0;
}