//Falcon-180B DATASET v1.0 Category: Haunted House Simulator ; Style: creative
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the maximum number of rooms in the haunted house
#define MAX_ROOMS 10

// Define the structure of a room
typedef struct {
    char name[50];
    int is_haunted;
    int has_ghost;
    int has_treasure;
} Room;

// Function to generate a random room
void generate_room(Room* room) {
    room->is_haunted = rand() % 2;
    room->has_ghost = rand() % 2;
    room->has_treasure = rand() % 2;
}

// Function to print a room
void print_room(Room room) {
    printf("Room: %s\n", room.name);
    if (room.is_haunted) {
        printf("This room is haunted!\n");
    } else {
        printf("This room is not haunted.\n");
    }
    if (room.has_ghost) {
        printf("There is a ghost in this room!\n");
    } else {
        printf("There is no ghost in this room.\n");
    }
    if (room.has_treasure) {
        printf("You found treasure in this room!\n");
    } else {
        printf("There is no treasure in this room.\n");
    }
}

// Function to explore the haunted house
void explore_house(Room rooms[MAX_ROOMS]) {
    int num_rooms = rand() % MAX_ROOMS + 1;
    for (int i = 0; i < num_rooms; i++) {
        generate_room(&rooms[i]);
    }

    printf("Welcome to the haunted house!\n");
    for (int i = 0; i < num_rooms; i++) {
        print_room(rooms[i]);
    }
}

int main() {
    srand(time(NULL));
    Room rooms[MAX_ROOMS];
    explore_house(rooms);

    return 0;
}