//Falcon-180B DATASET v1.0 Category: Drone Remote Control ; Style: surprised
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define PI 3.14159265358979323846
#define G 9.81

typedef struct {
    double x, y, z, vx, vy, vz;
} Vector3D;

Vector3D drone;

void init() {
    drone.x = 0.0;
    drone.y = 0.0;
    drone.z = 0.0;
    drone.vx = 0.0;
    drone.vy = 0.0;
    drone.vz = 0.0;
}

void takeoff() {
    drone.vz = 5.0;
}

void land() {
    drone.vz = -5.0;
}

void move(double dx, double dy, double dz) {
    drone.vx = dx;
    drone.vy = dy;
    drone.vz = dz;
}

void update(double dt) {
    drone.x += drone.vx * dt;
    drone.y += drone.vy * dt;
    drone.z += drone.vz * dt;
    
    drone.vx += 0.0;
    drone.vy += 0.0;
    drone.vz += G;
}

void print_position() {
    printf("Position: (%lf, %lf, %lf)\n", drone.x, drone.y, drone.z);
}

int main() {
    init();
    takeoff();
    move(5.0, 0.0, 0.0);
    update(1.0);
    print_position();
    land();
    return 0;
}