//MISTRAL-7B DATASET v1.0 Category: Bitwise operations ; Style: minimalist
#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>

#define SWAP(a, b) do { uint32_t t = (a); (a) = (b); (b) = t; } while(0)

typedef union {
    struct {
        uint8_t a : 1;
        uint8_t b : 1;
        uint8_t c : 1;
        uint8_t d : 1;
        uint8_t e : 1;
        uint8_t f : 1;
        uint8_t g : 1;
        uint8_t h : 1;
    } bits;
    uint8_t byte;
} Bitfield;

void print_bitfield(const char *name, const Bitfield *bitfield) {
    printf("%s = 0x%02X ", name, bitfield->byte);
    printf("a=%u b=%u c=%u d=%u e=%u f=%u g=%u h=%u\n",
           bitfield->bits.a, bitfield->bits.b, bitfield->bits.c,
           bitfield->bits.d, bitfield->bits.e, bitfield->bits.f,
           bitfield->bits.g, bitfield->bits.h);
}

int main(int argc, char const *argv[]) {
    Bitfield a, b, c;

    a.byte = 0b11110110; // set fields a, d, f, g
    b.byte = 0b01101111; // set fields b, e, g, h

    SWAP(a.byte, b.byte); // swap bytes

    printf("Byte a = "); print_bitfield("a", &a);
    printf("Byte b = "); print_bitfield("b", &b);

    // AND operation
    c.byte = a.byte & b.byte;
    printf("Byte a AND b = "); print_bitfield("a AND b", &c);

    // OR operation
    c.byte = a.byte | b.byte;
    printf("Byte a OR b = "); print_bitfield("a OR b", &c);

    // XOR operation
    c.byte = a.byte ^ b.byte;
    printf("Byte a XOR b = "); print_bitfield("a XOR b", &c);

    // NOT operation
    c.byte = ~a.byte;
    printf("NOT Byte a = "); print_bitfield("NOT a", &c);

    // Left shift operation
    c.byte = a.byte << 2;
    printf("Byte a left shifted by 2 = "); print_bitfield("a << 2", &c);

    // Right shift operation
    c.byte = a.byte >> 2;
    printf("Byte a right shifted by 2 = "); print_bitfield("a >> 2", &c);

    return 0;
}