//Falcon-180B DATASET v1.0 Category: Database querying ; Style: calm
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ROW 100
#define MAX_COL 100

typedef struct {
    char name[50];
    int id;
    float salary;
} Employee;

void createTable(FILE *fp) {
    fprintf(fp, "CREATE TABLE IF NOT EXISTS Employee (\n");
    fprintf(fp, "id INT PRIMARY KEY,\n");
    fprintf(fp, "name VARCHAR(50),\n");
    fprintf(fp, "salary FLOAT\n");
    fprintf(fp, ");\n");
}

void insertData(FILE *fp, Employee emp) {
    fprintf(fp, "INSERT INTO Employee (id, name, salary) VALUES (%d, '%s', %.2f);\n", emp.id, emp.name, emp.salary);
}

void selectData(FILE *fp, int id) {
    fprintf(fp, "SELECT * FROM Employee WHERE id = %d;\n", id);
}

void updateData(FILE *fp, int id, float newSalary) {
    fprintf(fp, "UPDATE Employee SET salary = %.2f WHERE id = %d;\n", newSalary, id);
}

void deleteData(FILE *fp, int id) {
    fprintf(fp, "DELETE FROM Employee WHERE id = %d;\n", id);
}

int main() {
    FILE *fp;
    fp = fopen("database.sql", "w");
    if (fp == NULL) {
        printf("Error: Unable to open file.\n");
        exit(1);
    }

    createTable(fp);
    insertData(fp, (Employee) {.id = 1,.name = "John Doe",.salary = 50000});
    insertData(fp, (Employee) {.id = 2,.name = "Jane Smith",.salary = 60000});

    selectData(fp, 1);
    updateData(fp, 1, 55000);
    deleteData(fp, 2);

    fclose(fp);
    return 0;
}