//MISTRAL-7B DATASET v1.0 Category: Dice Roller ; Style: Cyberpunk
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MIN_ROLL 1
#define MAX_ROLL 6
#define NUM_DICE 3
#define RED "\x1b[31m"
#define GREEN "\x1b[32m"
#define YELLOW "\x1b[33m"
#define BLUE "\x1b[34m"
#define PURPLE "\x1b[35m"
#define CYAN "\x1b[36m"
#define RESET "\x1b[0m"

void roll_dice(int num_dice, int sides, int roll_value[]) {
    int i;
    for (i = 0; i < num_dice; i++) {
        roll_value[i] = rand() % sides + 1;
    }
}

void print_roll(char* color, int roll[], int num_dice) {
    int i;
    printf(color);
    printf("You rolled: ");
    for (i = 0; i < num_dice; i++) {
        printf("%d", roll[i]);
        if (i < num_dice - 1) {
            printf(", ");
        }
    }
    printf("%s\n", RESET);
}

int main(void) {
    int roll_values[NUM_DICE];
    int i;

    srand(time(NULL));

    roll_dice(NUM_DICE, MAX_ROLL, roll_values);

    switch (rand() % 6) {
        case 0: printf("%s", RED); break;
        case 1: printf("%s", GREEN); break;
        case 2: printf("%s", YELLOW); break;
        case 3: printf("%s", BLUE); break;
        case 4: printf("%s", PURPLE); break;
        case 5: printf("%s", CYAN); break;
    }

    print_roll(CYAN, roll_values, NUM_DICE);

    for (i = 0; i < NUM_DICE; i++) {
        if (roll_values[i] > 4) {
            switch (roll_values[i] % 3) {
                case 0: printf("%sCritical Success!\n%s", RED, RESET); break;
                case 1: printf("%sSuccess with a twist!\n%s", YELLOW, RESET); break;
                case 2: printf("%sSuccess but with complications.\n%s", PURPLE, RESET); break;
            }
            break;
        } else {
            switch (roll_values[i] % 2) {
                case 0: printf("%sAverage roll.\n%s", GREEN, RESET); break;
                case 1: printf("%sBetter luck next time.\n%s", RED, RESET); break;
            }
        }
    }

    return EXIT_SUCCESS;
}