//GEMINI-pro DATASET v1.0 Category: Weather simulation ; Style: brave
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Weather types
enum weather_type {
    SUNNY,
    CLOUDY,
    RAINY,
    SNOWY,
    STORMY
};

// Weather simulation data
struct weather_data {
    enum weather_type type;
    int temperature;
    int humidity;
    int wind_speed;
};

// Function to generate a random weather simulation
struct weather_data generate_weather() {
    struct weather_data data;

    // Generate a random weather type
    data.type = rand() % 5;

    // Generate a random temperature
    data.temperature = rand() % 40;

    // Generate a random humidity
    data.humidity = rand() % 100;

    // Generate a random wind speed
    data.wind_speed = rand() % 100;

    return data;
}

// Function to print the weather simulation data
void print_weather(struct weather_data data) {
    switch (data.type) {
        case SUNNY:
            printf("The weather is sunny today.\n");
            break;
        case CLOUDY:
            printf("The weather is cloudy today.\n");
            break;
        case RAINY:
            printf("The weather is rainy today.\n");
            break;
        case SNOWY:
            printf("The weather is snowy today.\n");
            break;
        case STORMY:
            printf("The weather is stormy today.\n");
            break;
    }

    printf("The temperature is %d degrees Fahrenheit.\n", data.temperature);
    printf("The humidity is %d percent.\n", data.humidity);
    printf("The wind speed is %d miles per hour.\n", data.wind_speed);
}

// Main function
int main() {
    // Initialize the random number generator
    srand(time(NULL));

    // Generate a random weather simulation
    struct weather_data data = generate_weather();

    // Print the weather simulation data
    print_weather(data);

    return 0;
}