//GEMINI-pro DATASET v1.0 Category: Graph Coloring Problem ; Style: creative
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the number of colors
#define NUM_COLORS 4

// Define the number of vertices
#define NUM_VERTICES 10

// The graph represented as an adjacency matrix
int graph[NUM_VERTICES][NUM_VERTICES];

// The colors of the vertices
int colors[NUM_VERTICES];

// Function to check if a vertex can be colored with a given color
int is_safe(int vertex, int color) {
    for (int i = 0; i < NUM_VERTICES; i++) {
        if (graph[vertex][i] && colors[i] == color) {
            return 0;
        }
    }
    return 1;
}

// Function to find the next available color for a vertex
int get_next_color(int vertex) {
    for (int i = 0; i < NUM_COLORS; i++) {
        if (is_safe(vertex, i)) {
            return i;
        }
    }
    return -1;
}

// Function to color the graph
int color_graph() {
    // Initialize all vertices to uncolored
    for (int i = 0; i < NUM_VERTICES; i++) {
        colors[i] = -1;
    }

    // Color the first vertex with the first color
    colors[0] = 0;

    // Loop through the remaining vertices
    for (int i = 1; i < NUM_VERTICES; i++) {
        // Get the next available color for the vertex
        int color = get_next_color(i);

        // If no color is available, then the graph cannot be colored
        if (color == -1) {
            return 0;
        }

        // Color the vertex with the next available color
        colors[i] = color;
    }

    // The graph has been colored successfully
    return 1;
}

// Function to print the coloring of the graph
void print_coloring() {
    printf("The coloring of the graph is:\n");
    for (int i = 0; i < NUM_VERTICES; i++) {
        printf("Vertex %d: %d\n", i, colors[i]);
    }
}

// Main function
int main() {
    // Initialize the random number generator
    srand(time(NULL));

    // Generate a random graph
    for (int i = 0; i < NUM_VERTICES; i++) {
        for (int j = 0; j < NUM_VERTICES; j++) {
            graph[i][j] = rand() % 2;
        }
    }

    // Print the graph
    printf("The graph is:\n");
    for (int i = 0; i < NUM_VERTICES; i++) {
        for (int j = 0; j < NUM_VERTICES; j++) {
            printf("%d ", graph[i][j]);
        }
        printf("\n");
    }

    // Color the graph
    if (color_graph()) {
        // Print the coloring of the graph
        print_coloring();
    } else {
        printf("The graph cannot be colored.\n");
    }

    return 0;
}