//GPT-4o-mini DATASET v1.0 Category: Secure Password Generator ; Style: imaginative
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define PASSWORD_LENGTH 12
#define NUM_PASSWORDS 5

void generatePassword(char* password) {
    const char* lower = "abcdefghijklmnopqrstuvwxyz";
    const char* upper = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    const char* digits = "0123456789";
    const char* symbols = "!@#$%^&*()-_=+<>?";
    
    // Seed the random number generator
    srand((unsigned int)time(NULL));
    
    // Ensure at least one character from each category
    password[0] = lower[rand() % strlen(lower)];
    password[1] = upper[rand() % strlen(upper)];
    password[2] = digits[rand() % strlen(digits)];
    password[3] = symbols[rand() % strlen(symbols)];
    
    // Fill the rest of the password
    for (int i = 4; i < PASSWORD_LENGTH; i++) {
        int category = rand() % 4;
        if (category == 0) {
            password[i] = lower[rand() % strlen(lower)];
        } else if (category == 1) {
            password[i] = upper[rand() % strlen(upper)];
        } else if (category == 2) {
            password[i] = digits[rand() % strlen(digits)];
        } else {
            password[i] = symbols[rand() % strlen(symbols)];
        }
    }
    
    // Shuffle the password
    for (int i = 0; i < PASSWORD_LENGTH; i++) {
        int j = rand() % PASSWORD_LENGTH;
        char temp = password[i];
        password[i] = password[j];
        password[j] = temp;
    }
    
    // Null-terminate the string
    password[PASSWORD_LENGTH] = '\0';
}

void printPasswords(int count) {
    char password[PASSWORD_LENGTH + 1];
    printf("Your secure passwords are:\n");
    for (int i = 0; i < count; i++) {
        generatePassword(password);
        printf("Password %d: %s\n", i + 1, password);
    }
}

void displayInstructions() {
    printf("Welcome to the Magical Password Generator!\n");
    printf("===========================================\n");
    printf("This program will generate %d unique, secure passwords for you.\n", NUM_PASSWORDS);
    printf("Each password contains:\n");
    printf("- At least one uppercase letter\n");
    printf("- At least one lowercase letter\n");
    printf("- At least one number\n");
    printf("- At least one special character\n");
    printf("All passwords are %d characters long.\n", PASSWORD_LENGTH);
    printf("Prepare to enchant the digital realm with your new secure passwords!\n");
}

int main() {
    displayInstructions();
    
    printPasswords(NUM_PASSWORDS);
    
    printf("Thank you for using the Magical Password Generator!\n");
    printf("Use these passwords wisely!\n");
    
    return 0;
}