//Code Llama-13B DATASET v1.0 Category: File system simulation ; Style: synchronous
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>

#define MAX_FILENAME_LEN 256
#define MAX_FILE_SIZE 1024

typedef struct {
    char filename[MAX_FILENAME_LEN];
    char data[MAX_FILE_SIZE];
    size_t size;
} File;

int main() {
    File file1 = {"file1.txt", "This is the first file.", 19};
    File file2 = {"file2.txt", "This is the second file.", 20};

    // Create the first file
    int fd = open(file1.filename, O_CREAT | O_WRONLY, 0644);
    if (fd == -1) {
        perror("open");
        exit(1);
    }
    if (write(fd, file1.data, file1.size) != file1.size) {
        perror("write");
        exit(1);
    }
    if (close(fd) == -1) {
        perror("close");
        exit(1);
    }

    // Create the second file
    fd = open(file2.filename, O_CREAT | O_WRONLY, 0644);
    if (fd == -1) {
        perror("open");
        exit(1);
    }
    if (write(fd, file2.data, file2.size) != file2.size) {
        perror("write");
        exit(1);
    }
    if (close(fd) == -1) {
        perror("close");
        exit(1);
    }

    // Read the first file
    fd = open(file1.filename, O_RDONLY);
    if (fd == -1) {
        perror("open");
        exit(1);
    }
    char buffer[MAX_FILE_SIZE];
    ssize_t bytes_read = read(fd, buffer, file1.size);
    if (bytes_read != file1.size) {
        perror("read");
        exit(1);
    }
    printf("Read %ld bytes from %s\n", bytes_read, file1.filename);
    if (close(fd) == -1) {
        perror("close");
        exit(1);
    }

    // Read the second file
    fd = open(file2.filename, O_RDONLY);
    if (fd == -1) {
        perror("open");
        exit(1);
    }
    bytes_read = read(fd, buffer, file2.size);
    if (bytes_read != file2.size) {
        perror("read");
        exit(1);
    }
    printf("Read %ld bytes from %s\n", bytes_read, file2.filename);
    if (close(fd) == -1) {
        perror("close");
        exit(1);
    }

    return 0;
}