//Falcon-180B DATASET v1.0 Category: Smart home light control ; Style: expert-level
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>
#include <time.h>
#include <math.h>

#define NUM_ROOMS 5
#define NUM_LIGHTS_PER_ROOM 3
#define NUM_TOTAL_LIGHTS (NUM_ROOMS * NUM_LIGHTS_PER_ROOM)

typedef struct {
    char name[20];
    int room_num;
    bool is_on;
    float brightness;
} light_t;

light_t lights[NUM_TOTAL_LIGHTS];

void init_lights() {
    printf("Initializing lights...\n");
    for (int i = 0; i < NUM_TOTAL_LIGHTS; i++) {
        lights[i].is_on = false;
        lights[i].brightness = 0;
    }
}

void turn_on_light(int light_num) {
    printf("Turning on light %d...\n", light_num);
    lights[light_num].is_on = true;
    lights[light_num].brightness = 1;
}

void turn_off_light(int light_num) {
    printf("Turning off light %d...\n", light_num);
    lights[light_num].is_on = false;
    lights[light_num].brightness = 0;
}

void set_brightness(int light_num, float brightness) {
    printf("Setting brightness of light %d to %.2f...\n", light_num, brightness);
    lights[light_num].brightness = brightness;
}

void print_lights() {
    printf("Current state of lights:\n");
    for (int i = 0; i < NUM_TOTAL_LIGHTS; i++) {
        printf("Light %d (%s): %s, brightness: %.2f\n", i+1, lights[i].name, lights[i].is_on? "on" : "off", lights[i].brightness);
    }
}

int main() {
    init_lights();
    turn_on_light(0);
    turn_on_light(3);
    set_brightness(1, 0.5);
    set_brightness(2, 0.8);
    print_lights();
    turn_off_light(0);
    turn_off_light(3);
    print_lights();
    return 0;
}