//GPT-4o-mini DATASET v1.0 Category: Network Ping Test ; Style: lively
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/ip_icmp.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <time.h>

#define PACKET_SIZE 64
#define PING_COUNT 4
#define TIMEOUT 1

struct ping_packet {
    struct icmphdr hdr;
    char msg[PACKET_SIZE - sizeof(struct icmphdr)];
};

unsigned short checksum(void *b, int len) {
    unsigned short *buf = b;
    unsigned int sum = 0;
    unsigned short result;

    for (sum = 0; len > 1; len -= 2)
        sum += *buf++;
    if (len == 1)
        sum += *(unsigned char *)buf;

    sum = (sum >> 16) + (sum & 0xFFFF);
    sum += (sum >> 16);
    result = ~sum;
    return result;
}

void ping(const char *ip_address) {
    int sockfd;
    struct sockaddr_in addr_ping;
    struct ping_packet packet;
    struct timeval tv_out;
    struct sockaddr_in r_addr;
    socklen_t addr_len = sizeof(r_addr);
    int n;
    char r_buf[PACKET_SIZE];

    sockfd = socket(AF_INET, SOCK_RAW, IPPROTO_ICMP);
    if (sockfd < 0) {
        perror("Socket creation failed");
        exit(1);
    }

    addr_ping.sin_family = AF_INET;
    addr_ping.sin_port = 0;
    addr_ping.sin_addr.s_addr = inet_addr(ip_address);
    memset(packet.msg, 0, sizeof(packet.msg));

    printf("Pinging %s with 64 bytes of data:\n", ip_address);

    for (int i = 0; i < PING_COUNT; i++) {
        packet.hdr.type = ICMP_ECHO;
        packet.hdr.un.echo.id = getpid();
        packet.hdr.un.echo.sequence = i + 1;
        packet.hdr.checksum = checksum(&packet, sizeof(packet));

        gettimeofday((struct timeval *)&packet.msg, NULL);
        
        n = sendto(sockfd, &packet, sizeof(packet), 0, (struct sockaddr *)&addr_ping, sizeof(addr_ping));
        if (n < 0) {
            perror("Send failed");
            continue;
        }

        printf("Ping request %d sent...\n", i + 1);

        tv_out.tv_sec = TIMEOUT;
        tv_out.tv_usec = 0;
        setsockopt(sockfd, SOL_SOCKET, SO_RCVTIMEO, (const char *)&tv_out, sizeof tv_out);
        
        n = recvfrom(sockfd, r_buf, sizeof(r_buf), 0, (struct sockaddr*)&r_addr, &addr_len);
        if (n < 0) {
            printf("Request timed out.\n");
            continue;
        }

        struct iphdr *ip_header = (struct iphdr *)r_buf;
        struct icmphdr *icmp_header = (struct icmphdr *)(r_buf + (ip_header->ihl * 4));

        if (icmp_header->type == ICMP_ECHOREPLY) {
            printf("Reply from %s: bytes=%d time=%.2f ms\n",
                inet_ntoa(r_addr.sin_addr), n, 
                (double)(tv_out.tv_sec - ((struct timeval *)&packet.msg)->tv_sec) * 1000 + 
                (double)(tv_out.tv_usec - ((struct timeval *)&packet.msg)->tv_usec) / 1000);
        } else {
            printf("Received invalid ICMP response type.\n");
        }

        sleep(1);
    }

    close(sockfd);
    printf("Pinging completed.\n");
}

int main(int argc, char *argv[]) {
    if (argc != 2) {
        fprintf(stderr, "Usage: %s <IP Address>\n", argv[0]);
        exit(EXIT_FAILURE);
    }

    ping(argv[1]);

    return 0;
}