//MISTRAL-7B DATASET v1.0 Category: Greedy Algorithms ; Style: innovative
#include <stdio.h>
#include <stdlib.h>

typedef struct Coin {
    int value;
    int count;
} Coin;

void print_coins(Coin coins[], int num_coins, int amount) {
    int i;
    printf("To make change of %d cents,\n", amount);
    for (i = 0; i < num_coins; i++) {
        if (coins[i].count > 0) {
            printf("%d coin(s) of %d cents each = %d cents\n",
                   coins[i].count, coins[i].value, coins[i].count * coins[i].value);
            amount -= coins[i].count * coins[i].value;
        }
    }
    if (amount > 0) {
        printf("Unable to make change for %d cents.\n", amount);
    }
}

int main(void) {
    int amount = 36;
    int coins[] = {1, 5, 10, 25};
    int num_coins = sizeof(coins) / sizeof(coins[0]);
    Coin coin_stack[num_coins];

    int i, j;
    for (i = 0; i < num_coins; i++) {
        coin_stack[i].value = coins[i];
        coin_stack[i].count = 0;
    }

    for (i = num_coins - 1; i >= 0; i--) {
        for (j = 0; j <= amount / coin_stack[i].value; j++) {
            if (amount - j * coin_stack[i].value >= 0) {
                coin_stack[i].count += j;
                amount -= j * coin_stack[i].value;
            }
        }
    }

    if (amount < 0) {
        printf("Unable to make change for %d cents.\n", -amount);
        return 1;
    }

    print_coins(coin_stack, num_coins, amount);
    return 0;
}