//LLAMA2-13B DATASET v1.0 Category: Phone Book ; Style: artistic
// A celestial phone book, where stars and galaxies are the contacts

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAX_NAME_LEN 20
#define MAX_NUMBER_LEN 10

// Define a structure to hold the contact information
struct contact {
    char name[MAX_NAME_LEN];
    char number[MAX_NUMBER_LEN];
};

// Define a function to read the contact information from a file
struct contact read_contact(FILE *file) {
    struct contact c;
    fscanf(file, "%19s %9s", c.name, c.number);
    return c;
}

// Define a function to write the contact information to a file
void write_contact(struct contact c, FILE *file) {
    fprintf(file, "%19s %9s", c.name, c.number);
}

// Define a function to print the contact information
void print_contact(struct contact c) {
    printf("%19s %9s\n", c.name, c.number);
}

int main() {
    // Open the phone book file in read-write mode
    FILE *file = fopen("phone_book.txt", "r+");

    // Check if the file exists and create it if it doesn't
    if (!file) {
        file = fopen("phone_book.txt", "w");
    }

    // Read the contact information from the file
    struct contact c = read_contact(file);

    // Print the contact information
    print_contact(c);

    // Add a new contact to the file
    struct contact new_contact = {
        .name = "Nebula",
        .number = "999-555-0000"
    };
    write_contact(new_contact, file);

    // Close the file
    fclose(file);

    return 0;
}