//Gemma-7B DATASET v1.0 Category: URL Sanitizer ; Style: retro
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#define MAX_URL_LENGTH 255

void sanitize_url(char *url)
{
    char *p = url;
    char *q = NULL;

    // Strip leading and trailing spaces
    while (*p && isspace(*p))
    {
        p++;
    }

    // Remove invalid characters
    while (*p)
    {
        if (!isalnum(*p) && *p != '-' && *p != '_')
        {
            q = p;
            *p = '\0';
        }
        else
        {
            p++;
        }
    }

    // Normalize case
    if (q)
    {
        char *r = url;
        for (p = r; *p; p++)
        {
            *p = tolower(*p);
        }
    }

    // Return sanitized URL
    return;
}

int main()
{
    char url[MAX_URL_LENGTH] = "This is a sample URL with invalid characters and spaces.";

    sanitize_url(url);

    printf("Sanitized URL: %s\n", url);

    return 0;
}