//Code Llama-13B DATASET v1.0 Category: System event logger ; Style: secure
// Example program in a secure style for logging system events

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>

// Struct to hold log entry
struct log_entry {
  int event_id;
  char *event_name;
  char *event_description;
};

// Global variables
struct log_entry log_entries[100];
int log_count = 0;

// Function to log a new event
void log_event(int event_id, char *event_name, char *event_description) {
  // Check if log is full
  if (log_count >= 100) {
    // If log is full, overwrite the oldest entry
    log_count--;
    log_entries[log_count] = log_entries[0];
  }

  // Add new entry to log
  log_entries[log_count].event_id = event_id;
  log_entries[log_count].event_name = event_name;
  log_entries[log_count].event_description = event_description;
  log_count++;
}

// Function to print all log entries
void print_log() {
  for (int i = 0; i < log_count; i++) {
    printf("Event ID: %d\n", log_entries[i].event_id);
    printf("Event Name: %s\n", log_entries[i].event_name);
    printf("Event Description: %s\n", log_entries[i].event_description);
    printf("\n");
  }
}

int main() {
  // Log some events
  log_event(1, "Event 1", "This is event 1");
  log_event(2, "Event 2", "This is event 2");
  log_event(3, "Event 3", "This is event 3");

  // Print all log entries
  print_log();

  return 0;
}