//Gemma-7B DATASET v1.0 Category: Bingo Simulator ; Style: interoperable
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_BINGO_NUM 9
#define NUM_ROWS 5
#define NUM_COLS 5

typedef struct BingoCard
{
    int numbers[NUM_ROWS][NUM_COLS];
    int marked[NUM_ROWS][NUM_COLS];
    int wins;
} BingoCard;

void initializeBingoCard(BingoCard *card)
{
    int i, j;
    for (i = 0; i < NUM_ROWS; i++)
    {
        for (j = 0; j < NUM_COLS; j++)
        {
            card->numbers[i][j] = 0;
            card->marked[i][j] = 0;
        }
    }
    card->wins = 0;
}

void generateBingoNumbers(BingoCard *card)
{
    int i, j, num;
    srand(time(NULL));
    for (i = 0; i < NUM_ROWS; i++)
    {
        for (j = 0; j < NUM_COLS; j++)
        {
            card->numbers[i][j] = rand() % MAX_BINGO_NUM + 1;
        }
    }
}

void markBingoNumber(BingoCard *card, int number)
{
    int i, j;
    for (i = 0; i < NUM_ROWS; i++)
    {
        for (j = 0; j < NUM_COLS; j++)
        {
            if (card->numbers[i][j] == number)
            {
                card->marked[i][j] = 1;
            }
        }
    }
}

int checkBingo(BingoCard *card)
{
    int i, j, win = 0;
    for (i = 0; i < NUM_ROWS; i++)
    {
        // Check rows
        for (j = 0; j < NUM_COLS; j++)
        {
            if (card->marked[i][j] == 1)
            {
                win = 1;
            }
        }

        // Check columns
        for (j = 0; j < NUM_COLS; j++)
        {
            if (card->marked[j][i] == 1)
            {
                win = 1;
            }
        }

        // Check diagonals
        if (card->marked[0][0] == 1 && card->marked[NUM_ROWS - 1][NUM_COLS - 1] == 1)
        {
            win = 1;
        }
    }

    return win;
}

int main()
{
    BingoCard card;
    initializeBingoCard(&card);
    generateBingoNumbers(&card);

    markBingoNumber(&card, 12);
    markBingoNumber(&card, 15);
    markBingoNumber(&card, 16);
    markBingoNumber(&card, 22);

    if (checkBingo(&card))
    {
        printf("Congratulations! You won!\n");
    } else
    {
        printf("Sorry, you lost.\n");
    }

    return 0;
}