//Gemma-7B DATASET v1.0 Category: Temperature monitor ; Style: Donald Knuth
#include <stdio.h>
#include <stdlib.h>

#define MAX_TEMPERATURE 100
#define MAX_Readings 10

typedef struct Reading {
  int timestamp;
  int temperature;
} Reading;

Reading readings[MAX_Readings];

void initialize_readings() {
  for (int i = 0; i < MAX_Readings; i++) {
    readings[i].timestamp = -1;
    readings[i].temperature = -1;
  }
}

void add_reading(int timestamp, int temperature) {
  for (int i = 0; i < MAX_Readings; i++) {
    if (readings[i].timestamp == -1) {
      readings[i].timestamp = timestamp;
      readings[i].temperature = temperature;
      return;
    }
  }
  printf("Error: Readings array full!\n");
}

void print_readings() {
  printf("Timestamp | Temperature\n");
  printf("------------------------\n");
  for (int i = 0; i < MAX_Readings; i++) {
    if (readings[i].timestamp != -1) {
      printf("%d | %d\n", readings[i].timestamp, readings[i].temperature);
    }
  }
}

int main() {
  initialize_readings();

  // Add some readings
  add_reading(123456, 25);
  add_reading(123457, 22);
  add_reading(123458, 27);

  // Print the readings
  print_readings();

  return 0;
}