//Gemma-7B DATASET v1.0 Category: Medical Store Management System ; Style: ultraprecise
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

// Define the maximum number of items
#define MAX_ITEMS 100

// Define the structure of an item
typedef struct Item {
    char name[50];
    int quantity;
    float price;
} Item;

// Create an array of items
Item items[MAX_ITEMS];

// Function to add an item to the array
void addItem(char* name, int quantity, float price) {
    int i = 0;
    for (i = 0; i < MAX_ITEMS && items[i].name[0] != '\0'; i++) {}
    strcpy(items[i].name, name);
    items[i].quantity = quantity;
    items[i].price = price;
}

// Function to find an item in the array
Item* findItem(char* name) {
    int i = 0;
    for (i = 0; i < MAX_ITEMS && items[i].name[0] != '\0'; i++) {
        if (strcmp(items[i].name, name) == 0) {
            return &items[i];
        }
    }
    return NULL;
}

// Function to update the quantity of an item
void updateQuantity(char* name, int quantity) {
    Item* item = findItem(name);
    if (item) {
        item->quantity = quantity;
    }
}

// Function to display the list of items
void displayItems() {
    int i = 0;
    for (i = 0; i < MAX_ITEMS && items[i].name[0] != '\0'; i++) {
        printf("%s - %d - %.2f\n", items[i].name, items[i].quantity, items[i].price);
    }
}

int main() {
    // Add some items to the array
    addItem("Apple", 10, 1.20);
    addItem("Banana", 5, 1.50);
    addItem("Orange", 7, 1.30);

    // Display the list of items
    displayItems();

    // Update the quantity of the apple
    updateQuantity("Apple", 15);

    // Display the updated list of items
    displayItems();

    return 0;
}