//GEMINI-pro DATASET v1.0 Category: Product Inventory System ; Style: Cryptic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PRODUCTS 100
#define MAX_NAME_LEN 50
#define MAX_DESC_LEN 100

typedef struct product {
  char name[MAX_NAME_LEN];
  char description[MAX_DESC_LEN];
  int quantity;
  float price;
} product_t;

product_t products[MAX_PRODUCTS];
int num_products = 0;

void add_product(product_t product) {
  if (num_products == MAX_PRODUCTS) {
    printf("Error: too many products.\n");
  } else {
    products[num_products++] = product;
  }
}

void print_products() {
  for (int i = 0; i < num_products; i++) {
    printf("%s: %s (%d, $%.2f)\n", products[i].name, products[i].description, products[i].quantity, products[i].price);
  }
}

void find_product(char *name) {
  for (int i = 0; i < num_products; i++) {
    if (strcmp(products[i].name, name) == 0) {
      printf("Found product: %s\n", products[i].name);
      return;
    }
  }
  printf("Product not found.\n");
}

void remove_product(char *name) {
  for (int i = 0; i < num_products; i++) {
    if (strcmp(products[i].name, name) == 0) {
      for (int j = i + 1; j < num_products; j++) {
        products[j - 1] = products[j];
      }
      num_products--;
      printf("Product removed: %s\n", name);
      return;
    }
  }
  printf("Product not found.\n");
}

int main() {
  product_t product1 = {.name = "Product 1", .description = "This is product 1", .quantity = 10, .price = 10.0f};
  product_t product2 = {.name = "Product 2", .description = "This is product 2", .quantity = 20, .price = 20.0f};
  product_t product3 = {.name = "Product 3", .description = "This is product 3", .quantity = 30, .price = 30.0f};

  add_product(product1);
  add_product(product2);
  add_product(product3);

  print_products();

  find_product("Product 2");
  remove_product("Product 1");

  print_products();

  return 0;
}