//GEMINI-pro DATASET v1.0 Category: Cafe Billing System ; Style: curious
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 100
#define MAX_NAME_LEN 50
#define MAX_ITEM_DESC_LEN 100

struct Item {
    char name[MAX_NAME_LEN];
    char description[MAX_ITEM_DESC_LEN];
    float price;
};

struct Order {
    struct Item items[MAX_ITEMS];
    int num_items;
    float total_price;
};

void add_item(struct Order *order, struct Item item) {
    if (order->num_items < MAX_ITEMS) {
        order->items[order->num_items] = item;
        order->num_items++;
        order->total_price += item.price;
    } else {
        printf("Error: Order is full!\n");
    }
}

void print_order(struct Order order) {
    printf("Order Summary:\n");
    printf("---------------------\n");
    for (int i = 0; i < order.num_items; i++) {
        printf("%s (%s) - $%.2f\n", order.items[i].name, order.items[i].description, order.items[i].price);
    }
    printf("---------------------\n");
    printf("Total Price: $%.2f\n", order.total_price);
}

int main() {
    struct Order order;
    order.num_items = 0;
    order.total_price = 0.0;

    // Add some items to the order
    struct Item item1 = {"Coffee", "Hot and black", 2.50};
    struct Item item2 = {"Tea", "Hot and soothing", 1.50};
    struct Item item3 = {"Pastry", "Sweet and delicious", 3.00};
    add_item(&order, item1);
    add_item(&order, item2);
    add_item(&order, item3);

    // Print the order summary
    print_order(order);

    return 0;
}