//Falcon-180B DATASET v1.0 Category: Maze Route Finder ; Style: Dennis Ritchie
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define ROWS 10
#define COLS 10

void generateMaze(char maze[ROWS][COLS]);
void printMaze(char maze[ROWS][COLS]);
int isValid(int x, int y);
void path(int x, int y, char maze[ROWS][COLS]);

int main() {
    srand(time(0));
    char maze[ROWS][COLS];
    generateMaze(maze);
    printMaze(maze);
    return 0;
}

void generateMaze(char maze[ROWS][COLS]) {
    int i, j;
    for (i = 0; i < ROWS; i++) {
        for (j = 0; j < COLS; j++) {
            maze[i][j] = rand() % 2? '.' : '#';
        }
    }
}

void printMaze(char maze[ROWS][COLS]) {
    int i, j;
    for (i = 0; i < ROWS; i++) {
        for (j = 0; j < COLS; j++) {
            printf("%c", maze[i][j]);
        }
        printf("\n");
    }
}

int isValid(int x, int y) {
    if (x >= 0 && x < ROWS && y >= 0 && y < COLS) {
        return 1;
    }
    return 0;
}

void path(int x, int y, char maze[ROWS][COLS]) {
    int i, j;
    if (isValid(x, y)) {
        maze[x][y] = '*';
        if (x > 0 && maze[x - 1][y] == '.') {
            path(x - 1, y, maze);
        }
        if (y > 0 && maze[x][y - 1] == '.') {
            path(x, y - 1, maze);
        }
        if (x < ROWS - 1 && maze[x + 1][y] == '.') {
            path(x + 1, y, maze);
        }
        if (y < COLS - 1 && maze[x][y + 1] == '.') {
            path(x, y + 1, maze);
        }
    }
}