//Falcon2-11B DATASET v1.0 Category: Password Strength Checker ; Style: creative
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#define MIN_PASSWORD_LENGTH 8
#define MAX_PASSWORD_LENGTH 16
#define MIN_NUMBER_OF_SPECIAL_CHARACTERS 1
#define MIN_NUMBER_OF_UPPER_CASE_CHARACTERS 1
#define MIN_NUMBER_OF_NUMERIC_CHARACTERS 1

int main(void)
{
    char password[17];
    int special_char_count = 0, upper_case_count = 0, numeric_count = 0;

    // Take password from user
    printf("Enter password: ");
    fgets(password, sizeof(password), stdin);

    // Convert password to lower case
    for (int i = 0; password[i]!= '\0'; i++)
        password[i] = tolower(password[i]);

    // Check password length
    if (strlen(password) < MIN_PASSWORD_LENGTH || strlen(password) > MAX_PASSWORD_LENGTH)
    {
        printf("Password length is not valid.\n");
        return 1;
    }

    // Check for special characters
    for (int i = 0; password[i]!= '\0'; i++)
    {
        if (isalnum(password[i]))
            continue;
        else if (isdigit(password[i]))
            numeric_count++;
        else if (isupper(password[i]))
            upper_case_count++;
        else
            special_char_count++;
    }

    // Check for special characters
    if (special_char_count < MIN_NUMBER_OF_SPECIAL_CHARACTERS)
    {
        printf("Password does not have enough special characters.\n");
        return 1;
    }

    // Check for upper case characters
    if (upper_case_count < MIN_NUMBER_OF_UPPER_CASE_CHARACTERS)
    {
        printf("Password does not have enough upper case characters.\n");
        return 1;
    }

    // Check for numeric characters
    if (numeric_count < MIN_NUMBER_OF_NUMERIC_CHARACTERS)
    {
        printf("Password does not have enough numeric characters.\n");
        return 1;
    }

    printf("Password is strong.\n");
    return 0;
}