//Falcon-180B DATASET v1.0 Category: Warehouse Management System ; Style: shape shifting
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 100

typedef struct {
    char name[50];
    int quantity;
    float price;
} Item;

void addItem(Item* items, int count, char* name, int qty, float price) {
    if (count >= MAX_ITEMS) {
        printf("Error: Maximum number of items reached.\n");
        return;
    }

    strcpy(items[count].name, name);
    items[count].quantity = qty;
    items[count].price = price;

    printf("Item added successfully.\n");
}

void removeItem(Item* items, int count, char* name) {
    int i;

    for (i = 0; i < count; i++) {
        if (strcmp(items[i].name, name) == 0) {
            memmove(&items[i], &items[i+1], (count - i - 1) * sizeof(Item));
            count--;
            printf("Item removed successfully.\n");
            return;
        }
    }

    printf("Item not found.\n");
}

void updateItem(Item* items, int count, char* name, int qty, float price) {
    int i;

    for (i = 0; i < count; i++) {
        if (strcmp(items[i].name, name) == 0) {
            items[i].quantity = qty;
            items[i].price = price;
            printf("Item updated successfully.\n");
            return;
        }
    }

    printf("Item not found.\n");
}

void displayItems(Item* items, int count) {
    int i;

    for (i = 0; i < count; i++) {
        printf("%s - %d items - $%.2f\n", items[i].name, items[i].quantity, items[i].price);
    }
}

int main() {
    Item items[MAX_ITEMS];
    int count = 0;

    addItem(items, count, "Widget", 100, 5.99);
    addItem(items, count, "Gizmo", 50, 9.99);
    addItem(items, count, "Doodad", 25, 3.49);

    displayItems(items, count);

    removeItem(items, count, "Widget");

    displayItems(items, count);

    updateItem(items, count, "Gizmo", 75, 8.99);

    displayItems(items, count);

    return 0;
}