//GEMINI-pro DATASET v1.0 Category: TCP/IP Programming ; Style: complete
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

// Define the port number
#define PORT 8080

int main() {
    // Create a socket
    int sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd == -1) {
        perror("socket");
        exit(EXIT_FAILURE);
    }

    // Bind the socket to the port
    struct sockaddr_in servaddr;
    memset(&servaddr, 0, sizeof(servaddr));
    servaddr.sin_family = AF_INET;
    servaddr.sin_addr.s_addr = htonl(INADDR_ANY);
    servaddr.sin_port = htons(PORT);
    if (bind(sockfd, (struct sockaddr *)&servaddr, sizeof(servaddr)) == -1) {
        perror("bind");
        exit(EXIT_FAILURE);
    }

    // Listen for incoming connections
    if (listen(sockfd, 5) == -1) {
        perror("listen");
        exit(EXIT_FAILURE);
    }

    // Accept an incoming connection
    struct sockaddr_in cliaddr;
    socklen_t clilen = sizeof(cliaddr);
    int connfd = accept(sockfd, (struct sockaddr *)&cliaddr, &clilen);
    if (connfd == -1) {
        perror("accept");
        exit(EXIT_FAILURE);
    }

    // Print the client's IP address
    char *client_ip = inet_ntoa(cliaddr.sin_addr);
    printf("Client IP: %s\n", client_ip);

    // Read data from the client
    char buffer[1024];
    memset(buffer, 0, sizeof(buffer));
    int nread = read(connfd, buffer, sizeof(buffer));
    if (nread == -1) {
        perror("read");
        exit(EXIT_FAILURE);
    }

    // Print the data received from the client
    printf("Data received from client: %s\n", buffer);

    // Write data to the client
    char *message = "Hello, world!";
    int nwrite = write(connfd, message, strlen(message));
    if (nwrite == -1) {
        perror("write");
        exit(EXIT_FAILURE);
    }

    // Close the connection
    close(connfd);
    close(sockfd);

    return 0;
}