//GEMINI-pro DATASET v1.0 Category: Electronic Voting System ; Style: detailed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of candidates
#define MAX_CANDIDATES 10

// Define the structure of a candidate
typedef struct {
    char name[50];
    int votes;
} Candidate;

// Define the array of candidates
Candidate candidates[MAX_CANDIDATES];

// Define the number of candidates
int num_candidates = 0;

// Define the function to add a candidate
void add_candidate(char *name) {
    // Check if the number of candidates has reached the maximum
    if (num_candidates >= MAX_CANDIDATES) {
        printf("Error: Maximum number of candidates reached.\n");
        return;
    }

    // Copy the candidate's name into the array
    strcpy(candidates[num_candidates].name, name);

    // Initialize the candidate's votes to 0
    candidates[num_candidates].votes = 0;

    // Increment the number of candidates
    num_candidates++;
}

// Define the function to vote for a candidate
void vote(char *name) {
    // Find the candidate with the specified name
    int i;
    for (i = 0; i < num_candidates; i++) {
        if (strcmp(candidates[i].name, name) == 0) {
            break;
        }
    }

    // Check if the candidate was found
    if (i == num_candidates) {
        printf("Error: Candidate not found.\n");
        return;
    }

    // Increment the candidate's votes
    candidates[i].votes++;
}

// Define the function to print the results
void print_results() {
    // Find the candidate with the most votes
    int i;
    int max_votes = 0;
    int winner = -1;
    for (i = 0; i < num_candidates; i++) {
        if (candidates[i].votes > max_votes) {
            max_votes = candidates[i].votes;
            winner = i;
        }
    }

    // Print the winner's name
    printf("The winner is: %s\n", candidates[winner].name);
}

// Define the main function
int main() {
    // Add some candidates to the array
    add_candidate("John Smith");
    add_candidate("Jane Doe");
    add_candidate("Bob Jones");

    // Vote for some candidates
    vote("John Smith");
    vote("John Smith");
    vote("Jane Doe");
    vote("Bob Jones");

    // Print the results
    print_results();

    return 0;
}