//Gemma-7B DATASET v1.0 Category: Cafe Billing System ; Style: synchronous
#include <stdio.h>
#include <stdlib.h>

// Define the maximum number of items that can be ordered
#define MAX_ITEMS 10

// Define the structure of an item
typedef struct Item {
    char name[20];
    int quantity;
    double price;
} Item;

// Create an array of items
Item items[MAX_ITEMS];

// Function to add an item to the array
void addItem(char name, int quantity, double price) {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] == '\0') {
            strcpy(items[i].name, name);
            items[i].quantity = quantity;
            items[i].price = price;
            return;
        }
    }

    // If the array is full, print an error message
    printf("Error: The array is full.\n");
}

// Function to calculate the total cost of an order
double calculateTotalCost() {
    double totalCost = 0;
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] != '\0') {
            totalCost += items[i].quantity * items[i].price;
        }
    }

    return totalCost;
}

// Function to print the order
void printOrder() {
    printf("Order:\n");
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] != '\0') {
            printf("%s: %d @ %.2f\n", items[i].name, items[i].quantity, items[i].price);
        }
    }

    printf("Total cost: %.2f\n", calculateTotalCost());
}

int main() {
    // Add some items to the array
    addItem("Coffee", 5, 2.50);
    addItem("Tea", 3, 2.25);
    addItem("Juice", 2, 2.00);

    // Print the order
    printOrder();

    return 0;
}