//GEMINI-pro DATASET v1.0 Category: Memory management ; Style: secure
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Custom memory management functions
void *my_malloc(size_t size) {
    // Check for invalid size
    if (size == 0) {
        return NULL;
    }

    // Allocate memory from the heap
    void *ptr = malloc(size);

    // Check for allocation failure
    if (ptr == NULL) {
        return NULL;
    }

    // Initialize the allocated memory to 0
    memset(ptr, 0, size);

    // Return the pointer to the allocated memory
    return ptr;
}

void my_free(void *ptr) {
    // Check for null pointer
    if (ptr == NULL) {
        return;
    }

    // Free the allocated memory
    free(ptr);
}

// Example usage
int main() {
    // Allocate memory for a string
    char *str = (char *)my_malloc(100);

    // Check for allocation failure
    if (str == NULL) {
        return 1;
    }

    // Copy a string into the allocated memory
    strcpy(str, "Hello, world!");

    // Print the string
    printf("%s\n", str);

    // Free the allocated memory
    my_free(str);

    return 0;
}