//GEMINI-pro DATASET v1.0 Category: Greedy Algorithms ; Style: scientific
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

// A job structure to represent a job with a start time, end time, and profit.
typedef struct Job {
    int start;
    int end;
    int profit;
} Job;

// A function to compare two jobs based on their start times.
int compareJobs(const void *a, const void *b) {
    const Job *job1 = (const Job *)a;
    const Job *job2 = (const Job *)b;

    return job1->start - job2->start;
}

// A function to find the maximum profit from a set of jobs.
int findMaxProfit(Job jobs[], int n) {
    // Sort the jobs in ascending order of their start times.
    qsort(jobs, n, sizeof(Job), compareJobs);

    // Create a table to store the maximum profit for each job.
    int dp[n];
    dp[0] = jobs[0].profit;

    // Iterate over the remaining jobs.
    for (int i = 1; i < n; i++) {
        // Find the latest non-overlapping job.
        int prevJobIndex = -1;
        for (int j = i - 1; j >= 0; j--) {
            if (jobs[j].end <= jobs[i].start) {
                prevJobIndex = j;
                break;
            }
        }

        // Calculate the maximum profit for the current job.
        if (prevJobIndex == -1) {
            dp[i] = jobs[i].profit;
        } else {
            dp[i] = jobs[i].profit + dp[prevJobIndex];
        }
    }

    // Find the maximum profit from all the jobs.
    int maxProfit = 0;
    for (int i = 0; i < n; i++) {
        if (dp[i] > maxProfit) {
            maxProfit = dp[i];
        }
    }

    return maxProfit;
}

// A utility function to print a job.
void printJob(Job job) {
    printf("Job: [%d, %d, %d]\n", job.start, job.end, job.profit);
}

// A utility function to print a set of jobs.
void printJobs(Job jobs[], int n) {
    for (int i = 0; i < n; i++) {
        printJob(jobs[i]);
    }
}

// A main function to test the findMaxProfit() function.
int main() {
    // Create a set of jobs.
    Job jobs[] = {
        {0, 6, 10},
        {1, 4, 5},
        {3, 5, 15},
        {5, 7, 7},
        {7, 9, 6}
    };

    // Find the maximum profit from the set of jobs.
    int maxProfit = findMaxProfit(jobs, sizeof(jobs) / sizeof(Job));

    // Print the maximum profit.
    printf("Maximum profit: %d\n", maxProfit);

    // Print the jobs that contribute to the maximum profit.
    int prevJobIndex = -1;
    for (int i = sizeof(jobs) / sizeof(Job) - 1; i >= 0; i--) {
        if (maxProfit == jobs[i].profit + (prevJobIndex == -1 ? 0 : jobs[prevJobIndex].profit)) {
            printJob(jobs[i]);
            prevJobIndex = i;
            maxProfit -= jobs[i].profit;
        }
    }

    return 0;
}