//Gemma-7B DATASET v1.0 Category: Elevator Simulation ; Style: surprised
#include <stdlib.h>
#include <time.h>

#define NUM_FLOORS 10
#define MAX_PASSENGERS 5

typedef struct Passenger {
  char name[20];
  int floor;
  int destination;
} Passenger;

Passenger passengers[MAX_PASSENGERS];

void simulate_elevator(void) {
  int current_floor = 1;
  int num_passengers = 0;

  // Generate passengers
  for (int i = 0; i < MAX_PASSENGERS; i++) {
    passengers[i].name[0] = 'A' + i;
    passengers[i].floor = rand() % NUM_FLOORS + 1;
    passengers[i].destination = rand() % NUM_FLOORS + 1;
  }

  // Simulate elevator movement
  while (num_passengers > 0) {
    int destination = passengers[0].destination;

    // Move elevator to destination floor
    for (int i = current_floor; i != destination; i++) {
      current_floor++;
      printf("Elevator moving to floor %d.\n", current_floor);
      sleep(1);
    }

    // Passengers leave the elevator
    num_passengers--;
    printf("Passenger %s has left the elevator.\n", passengers[0].name);
    passengers[0].destination = 0;
  }

  // Elevator reaches top floor
  printf("Elevator has reached the top floor.\n");
}

int main() {
  simulate_elevator();

  return 0;
}