//GEMINI-pro DATASET v1.0 Category: Recursive ; Style: Claude Shannon
#include <stdio.h>

// Forward declaration of the Shannon entropy function
double shannon_entropy(int *values, int num_values);

// Calculate the Shannon entropy of an array of values
double shannon_entropy(int *values, int num_values) {
  // If the array is empty, return 0
  if (num_values == 0) {
    return 0;
  }

  // Calculate the probability of each value
  double probabilities[num_values];
  for (int i = 0; i < num_values; i++) {
    probabilities[i] = (double) values[i] / num_values;
  }

  // Calculate the entropy of each value
  double entropies[num_values];
  for (int i = 0; i < num_values; i++) {
    if (probabilities[i] == 0) {
      entropies[i] = 0;
    } else {
      entropies[i] = -probabilities[i] * log2(probabilities[i]);
    }
  }

  // Sum the entropies of all the values
  double entropy = 0;
  for (int i = 0; i < num_values; i++) {
    entropy += entropies[i];
  }

  return entropy;
}

int main() {
  // Define an array of values
  int values[] = {1, 2, 3, 4, 5};
  int num_values = sizeof(values) / sizeof(int);

  // Calculate the Shannon entropy of the array
  double entropy = shannon_entropy(values, num_values);

  // Print the entropy
  printf("The Shannon entropy of the array is: %f\n", entropy);

  return 0;
}