//GEMINI-pro DATASET v1.0 Category: Client Server Application ; Style: complex
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#define PORT 9001
#define MAX_SIZE 1024

int main() {
    // Create a socket.
    int sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) {
        perror("Error creating socket");
        exit(1);
    }

    // Bind the socket to an address and port.
    struct sockaddr_in serv_addr;
    memset(&serv_addr, 0, sizeof(serv_addr));
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_port = htons(PORT);
    serv_addr.sin_addr.s_addr = INADDR_ANY;

    if (bind(sockfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0) {
        perror("Error binding socket");
        exit(1);
    }

    // Listen for incoming connections.
    if (listen(sockfd, 5) < 0) {
        perror("Error listening for connections");
        exit(1);
    }

    // Accept an incoming connection.
    int connfd;
    struct sockaddr_in cli_addr;
    socklen_t cli_len = sizeof(cli_addr);
    connfd = accept(sockfd, (struct sockaddr *)&cli_addr, &cli_len);
    if (connfd < 0) {
        perror("Error accepting connection");
        exit(1);
    }

    // Read data from the client.
    char buffer[MAX_SIZE];
    memset(buffer, 0, MAX_SIZE);
    int n = read(connfd, buffer, MAX_SIZE - 1);
    if (n < 0) {
        perror("Error reading from client");
        close(connfd);
        exit(1);
    }

    // Process the data received from the client.
    printf("Received data from client: %s\n", buffer);

    // Send data back to the client.
    char *msg = "Hello from the server!";
    n = write(connfd, msg, strlen(msg));
    if (n < 0) {
        perror("Error writing to client");
        close(connfd);
        exit(1);
    }

    // Close the connection with the client.
    close(connfd);

    // Close the server socket.
    close(sockfd);

    return 0;
}