//MISTRAL-7B DATASET v1.0 Category: Movie Rating System ; Style: single-threaded
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_MOVIES 10
#define MAX_RATINGS 10

typedef struct {
    char title[50];
    int ratings[MAX_RATINGS];
    int num_ratings;
} Movie;

void init_movie(Movie *movie, const char *title) {
    strcpy(movie->title, title);
    movie->num_ratings = 0;
}

void add_rating(Movie *movie, int rating) {
    if (movie->num_ratings < MAX_RATINGS) {
        movie->ratings[movie->num_ratings++] = rating;
    }
}

double get_average_rating(const Movie *movie) {
    double sum = 0;
    int i;

    for (i = 0; i < movie->num_ratings; i++) {
        sum += movie->ratings[i];
    }

    if (movie->num_ratings > 0) {
        return sum / movie->num_ratings;
    }

    return 0;
}

int main() {
    Movie movies[MAX_MOVIES];
    int choice, movie_index, rating;

    printf("Movie Rating System\n");
    printf("--------------------\n");

    while (1) {
        printf("\nAvailable Movies:\n");
        for (int i = 0; i < MAX_MOVIES; i++) {
            if (movies[i].num_ratings > 0) {
                printf("%d. %s (Average Rating: %.1f)\n", i+1, movies[i].title, get_average_rating(&movies[i]));
            } else {
                printf("%d. %s\n", i+1, movies[i].title, "");
            }
        }

        printf("\n1. Rate a Movie\n2. Exit\n");
        scanf("%d", &choice);

        switch (choice) {
            case 1:
                printf("Enter Movie Title: ");
                char title[50];
                scanf("%s", title);

                for (movie_index = 0; movie_index < MAX_MOVIES; movie_index++) {
                    if (strcmp(movies[movie_index].title, title) == 0) {
                        printf("Enter Rating (1-10): ");
                        scanf("%d", &rating);
                        add_rating(&movies[movie_index], rating);
                        printf("Rating added successfully!\n");
                        break;
                    }
                }

                if (movie_index == MAX_MOVIES) {
                    printf("Movie not found. Please add a new movie.\n");
                    init_movie(&movies[MAX_MOVIES], title);
                    printf("Enter Rating (1-10): ");
                    scanf("%d", &rating);
                    add_rating(&movies[MAX_MOVIES], rating);
                    printf("Movie added successfully!\n");
                }
                break;
            case 2:
                printf("Exiting the program...\n");
                exit(0);
            default:
                printf("Invalid choice. Please try again.\n");
        }
    }

    return 0;
}