//Falcon-180B DATASET v1.0 Category: Bitwise operations ; Style: real-life
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Function to generate a random number between min and max
int rand_num(int min, int max) {
    return rand() % (max - min + 1) + min;
}

// Function to perform bitwise operations on two integers
void bitwise_ops(int num1, int num2) {
    // Bitwise AND
    int bitwise_and = num1 & num2;
    printf("Bitwise AND: %d\n", bitwise_and);

    // Bitwise OR
    int bitwise_or = num1 | num2;
    printf("Bitwise OR: %d\n", bitwise_or);

    // Bitwise XOR
    int bitwise_xor = num1 ^ num2;
    printf("Bitwise XOR: %d\n", bitwise_xor);

    // Bitwise NOT
    int bitwise_not = ~num1;
    printf("Bitwise NOT: %d\n", bitwise_not);

    // Left shift
    int left_shift = num1 << 2;
    printf("Left shift by 2: %d\n", left_shift);

    // Right shift
    int right_shift = num1 >> 2;
    printf("Right shift by 2: %d\n", right_shift);
}

int main() {
    srand(time(NULL)); // Seed the random number generator with the current time

    // Example usage of bitwise operations
    int num1 = rand_num(0, 255);
    int num2 = rand_num(0, 255);

    printf("Random number 1: %d\n", num1);
    printf("Random number 2: %d\n", num2);

    bitwise_ops(num1, num2);

    return 0;
}